function pa_fmri_set_parm(fig, fmri_parm)
% sets fmri parameters to fmri gui.
% [USAGE]
%    pa_fmri_set_parm(<fig> [,fmri_parm]);
% [IN]
%          fig : figure handle of fmri gui.
%    fmri_parm : to be set fmri_parm [default:vb_set_fmri_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

% default value
if isempty(fmri_parm)
    fmri_parm = vb_set_fmri_parm;
end

%
% --- Main Procedure
%

% load data(@see pa_fmri_create)
data = guidata(fig);

H = data.H; % component handles

% BRAIN file
set(H.brain_file_edit, 'String', fmri_parm.brain_file);

% SPM result file
if isfield(fmri_parm, 'SPMmat_file')
    set(H.spm_edit, 'String', fmri_parm.SPMmat_file);
    if exist(fmri_parm.SPMmat_file, 'file') == 2
        pa_fmri_util(fig, 'set_spm_result_file', fmri_parm.SPMmat_file);
    end
end

% SPM result type
if isfield(fmri_parm, 'SPMmapmode')
    switch(lower(fmri_parm.SPMmapmode))
        case {'mni2subj'}
            pa_fmri_util(fig, 'set_spm_type', 'mni2subj');
        case {'mni2mni'}
            pa_fmri_util(fig, 'set_spm_type', 'mni2mni');
        case {'subj2subj'}
            pa_fmri_util(fig, 'set_spm_type', 'subj2subj');
        otherwise
            error('Unknown fmri_parm.SPMmapmode is specified : %s', fmri_parm.SPMmapmode);
    end
end

% SPM normalization file
if isfield(fmri_parm, 'spm_normalization_file')
    set(H.spm_normalization_file_edit, 'String', fmri_parm.spm_normalization_file);
end

% Registration keys postfix
data.keys_postfix = '';
if isfield(fmri_parm, 'keys_postfix')
    data.keys_postfix = fmri_parm.keys_postfix;
end

% AREA file
set(H.area_file_edit, 'String', fmri_parm.area_file);

% ACT file
set(H.act_file_edit, 'String', fmri_parm.act_file);

% save data
data.fmri_parm = fmri_parm;
guidata(fig, data);

% view update
pa_fmri_util(fig, 'update_exec_push_status');
