function fig = pa_fmri_parm_gui_create(parent_fig, fmri_parm)
% This function creates gui for fmri advanced parameter.
% [USAGE]
%    fig = pa_fmri_parm_gui_create(<parent_fig> [,fmri_parm]);
% [IN]
%    parent_fig : figure handle of fmri parm gui.
%     fmri_parm : fmri parameter.
% [OUT]
%    fig : figure handle of fmri advanced parameter gui.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parent_fig', 'var')
    error('parent_fig is a required parameter.');
end
if ~exist('fmri_parm', 'var')
    fmri_parm = vb_set_fmri_parm;
end

%
% --- Main Procedure
%
fig = openfig('pa_fmri_parm_gui.fig');
H = guihandles(fig);

% save data
data = struct;
data.H = struct;

% save data
data.H = H;
data.H.figure = fig;
data.parent_fig = parent_fig;
guidata(fig, data);

% set parameter to gui
pa_fmri_parm_gui_set_parm(fig, fmri_parm);
