function fig = pa_brain_parm_gui_create(parent_fig, brain_parm)
%  This function creates gui for brain advanced parameter.
%  [USAGE]
%    fig = pa_brain_parm_gui_create(<parent_fig> [,brain_parm]);
%  [IN]
%    parent_fig : figure handle of brain parm gui.
%    brain_parm : brain parameter.
%  [OUT]
%    fig : figure handle of brain advanced parameter gui.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('parent_fig', 'var')
    error('parent_fig is a required parameter.');
end
if ~exist('brain_parm', 'var')
    brain_parm = vb_set_brain_parm;
end

%
% --- Main Procedure
%

fig = openfig('pa_brain_advanced.fig');

% save data
data = struct;
data.H = struct;
data.H = guihandles(fig);
data.H.figure = fig;
data.parent_fig = parent_fig;

H = data.H;

% save data
guidata(fig, data);

% Rmaxꤹslider롣
val     = 1000 * brain_parm.R_max;    % [m] -> [mm]
min_val = 0.0;  max_val = 100.0;
slider_step(1) = 1 / (max_val - min_val); % move amount(%) arrow is clicked
slider_step(2) = 10/ (max_val - min_val); % move amount(%) slider is clicked
set(H.rmax_slider,... 
    'sliderstep', slider_step,...
    'Min',min_val, 'Max',max_val, 'Value', val);

% Rmaxꤹedit롣
set(H.rmax_edit, 'String', num2str(val));

if isfield(brain_parm, 'Nvertex')
    set(H.nvertex_edit, 'String', num2str(brain_parm.Nvertex));
end

% Reduce ratioꤹslider롣
val     = brain_parm.reduce_ratio;
min_val = 0.0;  max_val = 1;
slider_step(1) = 0.1 / (max_val - min_val); % move amount(%) arrow is clicked
slider_step(2) = 1.0 / (max_val - min_val); % move amount(%) slider is clicked
set(H.reduce_ratio_slider, ...
    'sliderstep' , slider_step, ...
    'Min',min_val, 'Max', max_val, 'Value', val);

% Reduce ratioꤹedit롣
set(H.reduce_ratio_edit, 'String', num2str(val));

% N_stepꤹslider롣
val     = brain_parm.N_step;
min_val = 1;    max_val = 100.0;
slider_step(1) = 1 / (max_val - min_val); % move amount(%) arrow is clicked
slider_step(2) = 10/ (max_val - min_val); % move amount(%) slider is clicked
set(H.nstep_slider, ...
    'sliderstep', slider_step,...
    'Min',min_val, 'Max',max_val, 'Value', val);

% N_stepꤹedit롣
set(H.nstep_edit, 'String', num2str(val));

% displayꤹslider롣
val = brain_parm.display;
min_val = 1;    max_val = 1000;
slider_step(1) = 1 / (max_val - min_val); % move amount(%) arrow is clicked
slider_step(2) = 10/ (max_val - min_val); % move amount(%) slider is clicked
set(H.display_slider, ...
    'sliderstep', slider_step,...
    'Min',min_val, 'Max',max_val, 'Value', val);

% displayꤹedit롣
set(H.display_edit, 'String', num2str(val));

% save data
data.H = H;
data.H.figure = fig;
guidata(fig, data);

