function pa_biosemi_eeg_set_parm(fig, biosemi_eeg_parm)
% sets meg parameters to yokogawa meg gui.
% [USAGE]
%    pa_biosemi_eeg_set_parm(<fig>, [,biosemi_eeg_parm]);
% [IN]
%                  fig : figure handle of yokogawa meg gui.
%    biosemi_eeg_parm : to be set meg_parm[default:set_biosemi_eeg_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end

if isempty(biosemi_eeg_parm)
    % default value
    biosemi_eeg_parm = vb_set_meg_parm_biosemi;
end

%
% --- Main Procedure
%

% load data(@see pa_biosemi_eeg_create)
data = guidata(fig);
H = data.H; % component handles

% proj_root
proj_root = get(H.project_root_edit, 'String');

% bdf file
set(H.bdf_file_edit, 'String', biosemi_eeg_parm.measurement_file);

% position file
set(H.position_file_edit, 'String', biosemi_eeg_parm.pos_file);

% save dir
save_dir = vb_get_file_parts(biosemi_eeg_parm.output_file);
set(H.save_dir_edit, 'String', save_dir);

% EEG-MAT file
set(H.eegmat_file_edit, 'String', biosemi_eeg_parm.output_file);

% save data
data.biosemi_eeg_parm = biosemi_eeg_parm;
guidata(fig, data);

% view update
pa_biosemi_eeg_util(fig, 'update_output_fname');
pa_biosemi_eeg_util(fig, 'update_exec_push_status');
