function [current_parm] = current_gui_advanced_get_parm_gui(adv_fig)
% get advanced current parameter.
% [USAGE]
%    [current_parm] = current_gui_advanced_get_parm_gui(adv_fig);
% [IN]
%    adv_fig : current advanced parameter figure handle.
% [OUT]
%    current_parm : current_parm (which has only advanced parameter field.)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('adv_fig', 'var'), error('adv_fig is a required parameter.'); end

%
% --- Main Procedure
%

%
% --- Overlapped mode
%
data = guidata(adv_fig);
H = data.H;

current_parm = struct;
if get(H.overlapped_radiobutton, 'Value')
    current_parm.overlap_mode = 0; % overlapped
elseif get(H.concatenate_radiobutton, 'Value')
    current_parm.overlap_mode = 1; % concatenate
end

