function [result, cancelled] = brain_file_maker_smooth_brainfiles(...
                                    obj, parm)
% make smoothed brain files from brain files.
% [USAGE]
%    [result, cancelled] = 
%            brain_file_maker_smooth_brainfiles(<obj>, <parm>);
% [IN]
%           obj : brain_file_maker object
%          parm : parameter for smoothing
% [OUT]
%       result : SUCCESS or FAILURE
%              (FAILURE is returned when something error occured.)
%    cancelled : true or false
%              (true is returned when select 'Yes' at overwrite confirmation)
%
% Author: rhayashi
% Created: 2007-07-23
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

%
% --- Main Procedure
%
result = FAILURE;
cancelled = true;
h = []; % waiting dialog

%try
brain_parm = struct;

% analyze file
brain_parm.analyze_file = [vb_analyze_info_get_file_prefix(obj.analyze_info), '.hdr'];

brain_parm.brain_file = obj.brain_file;
brain_parm.area_file  = obj.area_file;
brain_parm.act_file   = obj.act_file;

% set struct:parm fields to brain_parm.
brain_parm = vb_merge_struct(brain_parm, parm);

% overwrite check
output_brain_file = vb_change_file_basename(brain_parm.brain_file, '_smooth');
output_brain_file = [obj.proj_root, filesep, output_brain_file];

if exist(output_brain_file, 'file') == 2
    res = questdlg('smoothed brain files already exist. overwrite?',...
                    'confirm', 'Yes', 'No', 'Yes');
    if strcmp(res, 'No')
        return;
    end
end

h = brain_file_maker_show_wait_dialog;
vb_job_smooth_cortex(obj.proj_root, brain_parm);
brain_file_maker_delete_wait_dialog(h);

result = SUCCESS;
cancelled = false;
%catch
%    result = FAILURE;
%    brain_file_maker_delete_wait_dialog(h);
%end

%
% --- After check
%
