function [obj] = brain_file_maker_set_selected_filename(obj)
% set selected filename to brain_file_marker object
% [USAGE]
%    [obj] = brain_file_maker_set_selected_filename(<obj>);
% [IN]
%    obj : brain_file_maker object
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
H = obj.H;
brain_files = get(H.brain_file_listbox, 'String');
area_files  = get(H.area_file_listbox, 'String');
act_files   = get(H.act_file_listbox, 'String');

brain_ix = get(H.brain_file_listbox, 'Value');
area_ix = get(H.area_file_listbox, 'Value');
act_ix  = get(H.act_file_listbox, 'Value');

if isempty(brain_files)
    brain_file = '';
else
    brain_file = ...
        [obj.brain_dir, filesep, brain_files{brain_ix}];
end
if isempty(area_files)
    area_file = '';
else
    area_file = ...
        [obj.brain_dir, filesep, area_files{area_ix}];
end
if isempty(act_files)
    act_file = '';
else
    act_file = ...
        [obj.brain_dir, filesep, act_files{act_ix}];
end

obj.brain_file = brain_file;
obj.area_file  = area_file;
obj.act_file   = act_file;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
