function [obj] = brain_file_maker_new(proj_root)
% constructor of brain_file_maker object
% [USAGE]
%    [obj] = brain_file_maker_new([proj_root]);
% [IN]
%    proj_root : project root directory(optional)
% [OUT]
%    obj : brain_file_maker object
%
% Author: rhayashi
% Created: 2007-07-13
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Object initialize
%
obj = struct;
obj.class_name = 'brain_file_maker';

if ~exist('proj_root', 'var')
    proj_root = '';
end
obj.proj_root    = proj_root;

obj.analyze_file = ''; % absolute path
obj.analyze_info = [];

obj.product_type = 1;  % = 1: subject cortex from std brain
                       % = 2: subject smooth cortex from mask file.

% for Brain Viewer & Smoother settings
obj.brain_dir    = ''; % relative path from proj_root
obj.brain_file   = ''; % relative path from proj_root
obj.act_file     = ''; % relative path from proj_root
obj.area_file    = ''; % relative path from proj_root
obj.job_smooth_cortex_parm = job_smooth_cortex_parm_new;

% Common settings to make brain files
obj.spm_norm_file    = '';          % absolute path
obj.brain_file_output_dir = '';     % relative path from proj_root
obj.brain_file_output_filename = '';
obj.output_brain_file = '';         % relative path from proj_root
obj.output_area_file  = '';         % relative path from proj_root
obj.output_act_file   = '';         % relative path from proj_root
obj.comment           = '';

% for making Smooth cortex from mask file
obj.output_mask_file = '';          % relative path from proj_root
obj.job_brain_std2sbj_parm = job_brain_std2sbj_parm_new;

% for making Cortex from standard brain model
obj.job_brain_model_std2sbj_parm = struct; % No Parameter

% for view
obj.view2d       = -1; % 2D view figure handle
obj.view3d       = -1; % 3D view figure handle

%
% --- Dialog instance
%

% analyze file input
obj.fdlg_analyze = file_dialog;
obj.fdlg_analyze.file_extensions = {'.hdr'};
obj.fdlg_analyze = set(obj.fdlg_analyze, 'current_dir', pwd);
obj.fdlg_analyze.dialog_title = 'Select analyze file';

% spm file input
obj.fdlg_spm_norm_file = file_dialog;
obj.fdlg_spm_norm_file.file_extensions = {'.mat'};
obj.fdlg_spm_norm_file = set(obj.fdlg_spm_norm_file, 'current_dir', pwd);
obj.fdlg_spm_norm_file.dialog_title = 'Select SPM normalization file';

%
% --- Figure open
%
fig = openfig('brain_file_maker.fig');
obj.H = guihandles(fig); % H.figure     : main figure handle
                         %  .object_tag : gui object handles

obj = brain_file_maker_update_display(obj);

% save application instance to figure
guidata(obj.H.figure, obj);
