function [result, cancelled] = brain_file_maker_make_mask_file(...
                        obj, spm_norm_file, standard_mask_file, mask_file)
% brain_file_maker_make_mask_file  One-line description here, please.
% [USAGE]
%    [output] = brain_file_maker_make_mask_file(<obj>)
% [IN]
%                   obj : brain_file_maker object
%         spm_norm_file : <<in>>personal spm normalization file(fullpath)
%    standard_mask_file : <<in>>standard mask map file         (fullpath)
%             mask_file : <<out>>output mask_file              (fullpath)
% [OUT]
%       result : make result of subject mask file. (SUCCESS or FAILURE)
%    cancelled : cancelled to make mask file.      (true or false)
%
% Author: rhayashi
% Created: 2007-07-12
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('spm_norm_file', 'var') || isempty(spm_norm_file)
    error('spm_norm_file is a required parameter.');
end
if ~exist('standard_mask_file', 'var') || isempty(standard_mask_file)
    error('standard_mask_file is a required parameter.');
end
if ~exist('mask_file', 'var') || isempty(mask_file)
    error('mask_file is a required parameter.');
end

%
% --- Main Procedure
%
result = SUCCESS;
cancelled = false;

if exist(mask_file, 'file') == 2
    res = questdlg('Mask file already exists, recreate it?', ...
                'confirm', 'Yes', 'No', 'Yes');
    if strcmp(res, 'No')
        cancelled = true;
        return;
    end
end
% try
    analyze_file = [vb_analyze_info_get_file_prefix(obj.analyze_info), '.hdr'];
    h = brain_file_maker_show_wait_dialog;
    [avw, XYZspm] = vb_map_mask_image(...
                        analyze_file, ...
                        standard_mask_file, ...
                        spm_norm_file);
    vb_fsave(mask_file, 'avw', 'XYZspm');
    brain_file_maker_delete_wait_dialog(h);
% catch
%     result = FAILURE;
% end
