function [obj] = state_new(state, description)
% create state object
% [USAGE]
%    [obj] = state_new(<status>[, description]);
% [IN]
%          state : state value.
%    description : <<string>> status explanation.
%
%    e.g. obj = state_new(ON, 'Switch is ON');
%
% [OUT]
%    obj : state object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% set class type
obj.class_type = 'state_new';

%
% --- Previous check
%
if ~exist('state', 'var'), error('state is a required parameter.'); end
if ~exist('description', 'var')
    description = [];
end


%
% --- Main Procedure
%
obj.state = [];
obj.description = [];
obj = state_set_state(obj, state, description);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
