function [const] = define_bm_edit_app()
% constant definition file for bm_edit_app.
% [USAGE]
%    [const] = define_bm_edit_app;
% [IN]
%    none
% [OUT]
%    const : constant value set
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

const = struct;

%
% --- Import file type
%
const.file_type = struct;
% Head file
const.file_type.HEAD_FILE  = 100;
% Brain file
const.file_type.BRAIN_FILE = 110;
% Curry file
const.file_type.CURRY_FILE = 120;
% Face file
const.file_type.FACE_FILE  = 130;
% MASK file
const.file_type.MASK_FILE  = 140;
% SPM NORM File
const.file_type.SPM_NORM_FILE = 150;


% brain_data type
const.brain_data_type.SURF_DATA       = 200;
const.brain_data_type.MASK_IMAGE_DATA = 201;

% surf_data status
const.surf_status.SURFACE_CLOSED     = 300;
const.surf_status.SURFACE_NOT_CLOSED = 301;

% Parameter type
const.parm_type = struct;
const.parm_type.SURF_SMOOTH_PARM          = 1;
const.parm_type.SURF_SMOOTH_EXPAND_PARM   = 2;
const.parm_type.SURF_TO_FILLED_MASK_PARM  = 3;
const.parm_type.SEPARATE_SURF_PARM        = 4;
const.parm_type.COMBINE_SURF_PARM         = 5;
const.parm_type.CLOSE_SURF_PARM           = 6;
const.parm_type.MORPHOLOGY_OPERATION_PARM = 7;
const.parm_type.SURF_EXTRACT_PARM         = 8;

% conductivity default
const.DEFAULT_CONDUCTIVITY = 0;

%
% --- STRING resources
%
const.str.BRAIN_FILE_IMPORT_LEFT_BRAIN  = 'Left brain';
const.str.BRAIN_FILE_IMPORT_RIGHT_BRAIN = 'Right brain';
const.str.BRAIN_FILE_IMPORT_WHOLE_BRAIN = 'Whole brain';
const.str.SPM_NORM_FILE_IMPORT_BRAIN    = 'Brain';
const.str.SPM_NORM_FILE_IMPORT_CORTEX   = 'Cortex';
const.str.MASK_FILE_IMPORT_BRAIN    = 'Brain';
const.str.MASK_FILE_IMPORT_CORTEX   = 'Cortex';
