function [bool_value] = surf_data_is_closed(obj)
% get surface status
% [USAGE]
%    [bool_value] = surf_data_get_status(<obj>);
% [IN]
%    obj : surf_data object
% [OUT]
%    bool_value : true  @ surface is closed.
%                 false @ surface is not closed.
%
%    status : status defined define_bm_edit_app()
%             SURFACE_CLOSED
%             SURFACE_NOT_CLOSED
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'surf_data')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
const = define_bm_edit_app;
switch(obj.status)
    case const.surf_status.SURFACE_CLOSED
        bool_value = true;
    case const.surf_status.SURFACE_NOT_CLOSED
        bool_value = false;
    otherwise
        error('surf_data status is invalid.');
end
