function [obj] = brain_data_set_conductivity(obj, conductivity)
% set conductivity
% [USAGE]
%    [obj] = brain_data_set_conductivity(<obj>, <conductivity>);
% [IN]
%             obj : brain_data object
%    conductivity : conductivity value
% [OUT]
%    obj : brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('conductivity', 'var')
    error('conductivity is a required parameter.');
end

%
% --- Main Procedure
%
obj.conductivity = conductivity;

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
