function [description_cell, parm_cell] = brain_data_get_history_item_all(obj)
% get description and parameter.
% [USAGE]
%    [description_cell, parm_cell] = brain_data_get_history_item_all(<obj>);
% [IN]
%    obj : brain_data object
% [OUT]
%    description_cell : description of processing (Nx1)
%           parm_cell : structure of processing   (Nx1)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
Nitem = history_get_length(obj.history);

description_cell = cell(Nitem, 1);
parm_cell        = cell(Nitem, 1);

for k=1:Nitem
    [description, parm] = history_get_item(obj.history, k);
    description_cell{k} = description;
    parm_cell{k} = parm;
end

