function [new_model_cell] = bm_processor_process(obj, brain_data_cell, parm_type, parm)
% process brain model
% [USAGE]
%   [new_model_cell] = 
%       bm_processor_process(<obj>, <brain_data_cell>, <parm_type>, <parm>)
% [IN]
%                obj : bm_processor object
%    brain_data_cell : cell of brain_data object.
%          parm_type : processing parameter type
%               parm : parameter structure
% [OUT]
%    new_model_cell  : cell of processed brain_data object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data_cell', 'var')
    error('brain_data_cell is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

%
% --- Main Procedure
%
brain_data = brain_data_cell{1};

history = brain_data_get_history(brain_data);
const = define_bm_edit_app;
type = const.parm_type;
new_model_cell = cell(0);

proc_str = [];
switch(parm_type)
    case type.SURF_SMOOTH_PARM
        new_model_cell{1} = bm_processor_surf_smooth(obj, brain_data, parm);
        proc_str = 'vb_surf_smooth()';
    case type.SURF_SMOOTH_EXPAND_PARM
        new_model_cell{1} = bm_processor_surf_smooth_expand(obj, brain_data, parm);
        proc_str = 'vb_surf_smooth_expand()';
    case type.SURF_TO_FILLED_MASK_PARM
        new_model_cell{1} = bm_processor_surf_to_filled_mask(obj, brain_data, parm);
        proc_str = 'vb_surf_to_filled_mask()';
    case type.SEPARATE_SURF_PARM
        new_model_cell = bm_processor_separate_surf(obj, brain_data, parm);
        proc_str = 'vb_separate_surf()';
    case type.COMBINE_SURF_PARM
        new_model_cell{1} = bm_processor_combine_surf(obj, brain_data_cell, []);
        proc_str = 'vb_combine_surf() : ';
        Nmodel = length(brain_data_cell);
        for k=1:Nmodel
            data = brain_data_cell{k};
            model_name = brain_data_get_model_name(data);
            proc_str = [proc_str, model_name];
            if k ~= Nmodel
               proc_str = [proc_str, ' & '];
            end
        end
        history = history_new;
    case type.CLOSE_SURF_PARM
        new_model_cell{1} = bm_processor_close_surf(obj, brain_data, parm);
        proc_str = 'vb_close_surf()';
    case type.MORPHOLOGY_OPERATION_PARM
        new_model_cell{1} = bm_processor_morphology_operation(obj, brain_data, parm);
        proc_str = 'vb_morphology_operation()';
    case type.SURF_EXTRACT_PARM
        new_model_cell{1} = bm_processor_surf_extract(obj, brain_data, parm);
        proc_str = 'vb_surf_extract()';
end

Nmodel = length(new_model_cell);
for k=1:Nmodel
    copied_history = history;
    copied_history = history_add_item(copied_history, proc_str, parm);
    new_model_cell{k} = brain_data_set_history(new_model_cell{k}, copied_history);
end
