function [new_brain_data] = bm_processor_morphology_operation(...
                                                        obj, brain_data, parm)
% processing by vb_morphology_operation()
% [USAGE]
%     [new_brain_data] =
%         bm_processor_process_morphology_operation(<brain_data>, <parm>);
% [IN]
%           obj : bm_processor object
%    brain_data : processing data
%          parm : processing parameter
% [OUT]
%    new_brain_data : processed data
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data', 'var')
    error('brain_data is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

if ~strcmp(brain_data.class_type, 'mask_image_data')
    error('Not mask_image_data was inputted.');
end


%
% --- Main Procedure
%
global vbmeg_inst;
const = vbmeg_inst.const;

% get processing data
B = mask_image_data_get_mask_image(brain_data);

% processing
B = vb_morphology_operation(B, parm.Radius, parm.step);

% create new data
new_brain_data = mask_image_data_new(B, parm.step, ...
                                    const.COORDINATE_ANALYZE_RIGHT_MM);
