function [new_brain_data] = bm_processor_close_surf(obj, brain_data, parm)
% processing by vb_close_surf()
% [USAGE]
%     [new_brain_data] =
%         bm_processor_close_surf(<obj>, <brain_data>, <parm>);
% [IN]
%    brain_data : processing data
%          parm : processing parameter
% [OUT]
%    new_brain_data : processed data
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data', 'var')
    error('brain_data is a required parameter.');
end
if ~exist('parm', 'var'), error('parm is a required parameter.'); end

if ~strcmp(brain_data.class_type, 'surf_data')
    error('Not surface data was inputted.');
end


%
% --- Main Procedure
%

% get processing data
V  = surf_data_get_vertex(brain_data);
F  = surf_data_get_face(brain_data);
xx = surf_data_get_normal_vector(brain_data);
coord_type = brain_data_get_coord_type(brain_data);

% processing
[F_new, V_new, xx_new] = vb_close_surf(F, V);

% create new data
new_brain_data = surf_data_new(V_new, F_new, xx_new, coord_type);
