function [proc_parm] = bm_process_parm_list_get_parameter(obj, parm_type)
% get processing parameter
% [USAGE]
%    [proc_parm] = bm_process_parm_list_get_parameter(obj, <parm_type>);
% [IN]
%          obj : bm_process_parm_list object
%    parm_type : parameter type
% [OUT]
%    proc_parm : bm_process_parm object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%
const = define_bm_edit_app;
type = const.parm_type;

switch(parm_type)
case type.SURF_SMOOTH_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.surf_smooth_parameter);
case type.SURF_SMOOTH_EXPAND_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.surf_smooth_expand_parameter);
case type.SURF_TO_FILLED_MASK_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.surf_to_filled_mask_parameter);
case type.SEPARATE_SURF_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.separate_surf_parameter);
case type.COMBINE_SURF_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.combine_surf_parameter);
case type.CLOSE_SURF_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.close_surf_parameter);
case type.MORPHOLOGY_OPERATION_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.morphology_operation_parameter);
case type.SURF_EXTRACT_PARM
    proc_parm = ...
        bm_process_parm_get_parameter(obj.surf_extract_parameter);
end

