function [obj, result] = bm_process_parm_set_parameter(obj, parm)
% set parameter from inherit objects.
% [USAGE]
%    [obj] = bm_process_parm_set_parameter(<obj>, <parm>);
% [IN]
%    obj : bm_process_parm object
% [OUT]
%      parm : parameter structure defined in inherit class.
%    result : set result.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
result = bm_process_parm_check_parameter(obj);
if result == FAILURE;
    return;
else
    obj.parm = parm;
end

%
% --- After check
%
if nargout ~= 2
    error('function caller should receive obj and result.');
end
