function [obj, result, index] = bm_manager_import_file(...
                                    obj, file_type, model_file, analyze_file, varargin)
% import brain model
% [USAGE]
%    bm_manager_import_file(<obj>, <file_type>, <model_file>, <analyze_file>);
% [IN]
%             obj : bm_manager object
%       file_type : import file type
%      model_file : import file name
%    analyze_file : analyze file
%        varargin : other paramters
% [OUT]
%       obj : bm_manager object
%    result : brain model import result.
%             (SUCESS or FAILURE)
%     index : imported brain model list index
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_manager')
    error('class type is invalid.');
end
if ~exist('file_type', 'var')
    error('file_type is a required parameter.');
end
if ~exist('model_file', 'var')
    error('model_file is a required parameter.');
end
if ~exist('analyze_file', 'var') || isempty(analyze_file) || ...
   exist(analyze_file, 'file') ~= 2
    error('analyze_file is a required parameter.');
end

%
% --- Main Procedure
%

% read analyze information to convert coordinate
[obj.analyze_info, result] = vb_analyze_info_new(analyze_file);
if result == FAILURE
    error('analyze file read failed.');
else
    % set analyze information to processor to convert coordinate.
    obj.processor = bm_processor_set_analyze_info(obj.processor,...
                                                     obj.analyze_info);
end

% Data import
bm_fileio = bm_fileio_new;
[bm_fileio, result] = bm_fileio_import_file(bm_fileio, ...
                                                file_type, ...
                                                model_file, ...
                                                obj.analyze_info, ...
                                                varargin);
if result == SUCCESS
    imported_bm_list = bm_fileio_get_bm_list(bm_fileio);
    % merge bm_list and imported bm_list
    obj.bm_list = bm_list_merge_bm_list(obj.bm_list, imported_bm_list);
    index = bm_list_get_brain_model_index(obj.bm_list);
else
    index = [];
    return;
end

%
% --- After check
%
if nargout == 0
    error('function caller should receive obj.');
end
