function [display_factor] = bm_manager_get_display_factor(obj, index)
% get structure including display elements.
% [USAGE]
%    [display_factor] = bm_manager_get_display_factor(<obj>, <index>);
% [IN]
%      obj : bm_manager object
%    index : bm_list index
% [OUT]
%    display_factor : structure including display elements.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

brain_data_cell = bm_list_get_brain_model(obj.bm_list, index);
Nelements = length(brain_data_cell);

display_factor = vb_display_factor_new;

for k=1:Nelements
    brain_data = brain_data_cell{k};
    model_name = brain_data_get_model_name(brain_data);
    coord_type = brain_data_get_coord_type(brain_data);
    element = struct;

    switch(brain_data.class_type)
        case 'surf_data'
            % surf_element
            V           = surf_data_get_vertex(brain_data);
            F           = surf_data_get_face(brain_data);
            xx          = surf_data_get_normal_vector(brain_data);
            element = vb_surf_element_new(model_name, coord_type, V, F, xx);
        case 'mask_image_data'
            % mask_image_data_element
            B       = mask_image_data_get_mask_image(brain_data);
            step    = mask_image_data_get_step(brain_data);
            element = vb_mask_image_element_new(model_name, coord_type, B, step);
    end

    display_factor = vb_display_factor_add_element(display_factor, element);
end
