function [obj] = bm_manager_delete_model(obj, index)
% delete brain model
% [USAGE]
%    [obj] = bm_manager_delete_model(<obj>, <index>);
% [IN]
%      obj : bm_manager object
%    index : brain model list index(Nx1)
% [OUT]
%    obj : bm_manager object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('index', 'var')
    error('index is a required parameter.');
end

%
% --- Main Procedure
%
obj.bm_list = bm_list_delete_model(obj.bm_list, index);
