function [obj] = bm_list_merge_bm_list(obj, merged_bm_list)
% merge two bm_list
% [USAGE]
%    [obj] = bm_list_merge_bm_list(<obj>, <merged_bm_list>);
% [IN]
%               obj : base bm_list
%    merged_bm_list : merged bm_list
% [OUT]
%    obj : base bm_list
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('merged_bm_list', 'var')
    error('merged_bm_list is a required parameter.');
end

%
% --- Main Procedure
%
obj.brain_data_list = [obj.brain_data_list, merged_bm_list.brain_data_list];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
