function [obj, index] = bm_list_add_model(obj, brain_data)
% add brain_data to list
% [USAGE]
%    [obj, index] = bm_list_add_model(<obj>, <brain_data>);
% [IN]
%           obj : bm_list object
%    brain_data : brain_data object
% [OUT]
%    index : after added index of bm_list.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~exist('brain_data', 'var')
    error('brain_data is a required parameter.');
end
if ~strcmp(obj.class_type, 'bm_list')
    error('class type is invalid.');
end

%
% --- Main Procedure
%

% regist model
Nmodel = length(obj.brain_data_list);
obj.brain_data_list{Nmodel+1} = brain_data;

% return index
index = bm_list_get_brain_model_index(obj);

%
% --- After check
%
if nargout == 0
    error('function caller should receive obj and index');
end
