function [file_name, cancelled] = bm_edit_app_util_get_file(extension, caption)
% file selection dialog
% [USAGE]
%    [file_name, cancelled] = bm_edit_app_util_get_file(<extension>, <caption>);
% [IN]
%    extension : cell array
%                ex.{'.brain.mat', '.head.mat'};
%    caption   : dialog caption
% [OUT]
%    file_name : selected file path(fullpath).
%    cancelled : true  @ when user pushed cancel button.
%                false @ user selected file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('extension', 'var')
    error('extension is a required parameter.');
end

if ~exist('caption', 'var')
    error('caption is a required parameter.');
end

%
% --- Main Procedure
%
cancelled = false;
file_name = [];

%
% --- file dialog open
%

% save current directory
current_dir = pwd;

% change to previous opened directory
previous_opened = [tempdir, 'bm_edit_app_util_get_file.mat'];
previous_dir = [];
if exist(previous_opened, 'file') ~= 2
    previous_dir = pwd;
else
    load(previous_opened, 'pname');
    previous_dir = pname;
    if exist(previous_dir, 'dir') ~= 7
        previous_dir = pwd;
    end
end
cd(previous_dir);

file_name = [];
h = file_dialog;
h.save_mode = 0;
h.file_extensions = extension;
[ pname fname ] = visible(h);
if length(pname)
    file_name = fullfile(pname, fname{1});
    % save opened directory
    vb_fsave(previous_opened, 'pname');
else
    cancelled = true;
end


% move to first directory
cd(current_dir);

% wait for redraw
pause(0.01);
