function [obj] = bm_edit_app_update_brain_model_listbox(obj)
% update brain model listbox
% [USAGE]
%    [obj] = bm_edit_app_update_brain_model_listbox(<obj>);
% [IN]
%    obj : bm_edit_app object
% [OUT]
%    obj : bm_edit_app object
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end
if ~strcmp(obj.class_type, 'bm_edit_app')
    error('class type is invalid.');
end

%
% --- Main Procedure
%
H = guihandles(obj.h);

% get all brain model name and set listbox
all_index = bm_manager_get_bm_list_index(obj.bmm);
if isempty(all_index)
    model_name_cell = [];
else
    model_name_cell = bm_manager_get_model_name(obj.bmm, all_index);
end
set(H.brain_model_list_listbox, 'String', model_name_cell);

% update 2D view if opening
if ~isempty(obj.view2d) && bm_edit_app_view_is_opening(obj.view2d)
    obj.view2d = ...
        bm_edit_app_view2d_update(obj.view2d, obj, ...
                                  @bm_edit_app_get_display_factor, ...
                                  obj.view_setting2d);
end

% update 3D view if opening
if ~isempty(obj.view3d) && bm_edit_app_view_is_opening(obj.view3d)
    obj.view3d = ...
        bm_edit_app_view3d_update(obj.view3d, obj, ...
                                  @bm_edit_app_get_display_factor,...
                                  obj.view_setting3d);
end

% update brain model status window
obj = bm_edit_app_update_model_status_listbox(obj);

% update history listbox
obj = bm_edit_app_update_history_listbox(obj);

% update ui status
obj = bm_edit_app_update_ui_state(obj);

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive obj.');
end
