function [map] = bm_edit_app_make_menu_map(obj)
% make mapping table between component and parm_type.
% [USAGE]
%    [map] = bm_edit_app_make_menu_map(<obj>);
% [IN]
%    obj : bm_edit_app object.
% [OUT]
%    map : menu <--> parm_type map table
%
% see : bm_edit_app_menu_to_parm_type
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('obj', 'var'), error('obj is a required parameter.'); end

%
% --- Main Procedure
%
const = define_bm_edit_app;
type = const.parm_type;

H = guihandles(obj.h); % all component handles

map = ...
    [H.processing_surf_smooth_menu         , type.SURF_SMOOTH_PARM;
     H.surf_smooth_push                    , type.SURF_SMOOTH_PARM;
     H.processing_surf_smooth_expand_menu  , type.SURF_SMOOTH_EXPAND_PARM;
     H.surf_smooth_expand_push             , type.SURF_SMOOTH_EXPAND_PARM;
     H.processing_surf_to_filled_mask_menu , type.SURF_TO_FILLED_MASK_PARM;
     H.surf_to_filled_mask_push            , type.SURF_TO_FILLED_MASK_PARM;
     H.processing_separate_surf_menu       , type.SEPARATE_SURF_PARM;
     H.separate_surf_push                  , type.SEPARATE_SURF_PARM;
     H.close_surf_push                     , type.CLOSE_SURF_PARM;
     H.processing_morphology_operation_menu, type.MORPHOLOGY_OPERATION_PARM;
     H.morphology_operation_push           , type.MORPHOLOGY_OPERATION_PARM;
     H.processing_surf_extract_menu        , type.SURF_EXTRACT_PARM;
     H.surf_extract_push                   , type.SURF_EXTRACT_PARM];
