function bm_edit_app_callback(obj, hObj)
% callback function. This funcion is called when gui is operated.
% [USAGE]
%     bm_edit_app_callback(<obj>, <hObj>);
% [IN]
%     obj : bm_edit_app object
%    hObj : action component.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var'),
    error('obj is a required parameter.');
end
if ~strcmp(obj.class_type, 'bm_edit_app')
    error('class type is invalid.');
end
if ~exist('hObj', 'var'), error('hObj is a required parameter.'); end


%
% --- Main Procedure
%
const = define_bm_edit_app;

% get component handles
H = guihandles(obj.h);

% disp(get(hObj, 'Tag'));

switch(hObj)
    case H.analyze_file_push
        % When analyze file reselection occurs models destruction.
        index = bm_manager_get_bm_list_index(obj.bmm);
        read_ok = true;
        if ~isempty(index)
            res = questdlg('Models are deleted, OK?', 'confirm', ...
                            'Yes', 'No', ...
                            'Yes');
            if strcmp(res, 'No'), read_ok = false; end
        end
        if ~read_ok, return; end

        % Select analyze_file
        [mri_file, cancelled] = ...
                    bm_edit_app_util_get_file({'.nii', '.hdr'}, 'Select MRI file');
        if ~cancelled
            % display filename
            set(H.analyze_file_edit, 'String', mri_file);
            % set view setting
            obj.view_setting2d = ...
                bm_view_parm2d_set_analyze_file(obj.view_setting2d, ...
                                                mri_file);
            % all model delete
            index = bm_manager_get_bm_list_index(obj.bmm);
            if ~isempty(index)
                obj.bmm = bm_manager_delete_model(obj.bmm, index);
                set(H.brain_model_list_listbox, 'Value', 1);
            end

            % update listbox state
            obj = bm_edit_app_update_brain_model_listbox(obj);
        else
            return;
        end

    %
    % --- Import brain model
    %
    case { H.brain_file_push, H.head_file_push, ...
           H.curry_file_push, H.face_file_push, ...
           H.mask_file_push,  H.spm_norm_file_push}
        opt_arg1 = []; opt_arg2 = []; opt_arg3 = [];

        % judge extension type
        if hObj == H.brain_file_push
            extension = {'.brain.mat'};
            caption   = 'Select brain file';
            file_type = const.file_type.BRAIN_FILE
        elseif hObj == H.head_file_push
            extension = {'.head.mat'};
            caption   = 'Select head file';
            file_type = const.file_type.HEAD_FILE;
        elseif hObj == H.curry_file_push
            extension = {'.*'};
            caption   = 'Select Curry file';
            file_type = const.file_type.CURRY_FILE;
        elseif hObj == H.face_file_push
            extension = {'.face.mat'};
            caption   = 'Select face file';
            file_type = const.file_type.FACE_FILE;
        elseif hObj == H.mask_file_push
            extension = {'.mat'};
            caption   = 'Select mask file';
            file_type = const.file_type.MASK_FILE;
        elseif hObj == H.spm_norm_file_push
            extension = {'.mat'};
            caption   = 'Select SPM normalization file';
            file_type = const.file_type.SPM_NORM_FILE;
        end

        % get model file
        [model_file, cancelled] = bm_edit_app_util_get_file(extension, caption);
        if cancelled, return; end

        % selection
        if hObj == H.brain_file_push
            prompt = {'Select hemisphere'};
            parts = {const.str.BRAIN_FILE_IMPORT_LEFT_BRAIN, ...
                     const.str.BRAIN_FILE_IMPORT_RIGHT_BRAIN, ...
                     const.str.BRAIN_FILE_IMPORT_WHOLE_BRAIN};
            [selection, IsOK] = listdlg('PromptString', prompt,...
                                        'SelectionMode', 'multiple', ...
                                        'ListString', parts);
            if ~IsOK, return; end
            opt_arg1 = parts(selection);
        elseif hObj == H.mask_file_push
            prompt = {'Select hemisphere'};
            parts = {const.str.MASK_FILE_IMPORT_BRAIN, ...
                     const.str.MASK_FILE_IMPORT_CORTEX};
            [selection, IsOK] = listdlg('PromptString', prompt,...
                                        'SelectionMode', 'multiple', ...
                                        'ListString', parts);
            if ~IsOK, return; end
            opt_arg1 = parts(selection);
        elseif hObj == H.spm_norm_file_push
            prompt = {'Select hemisphere'};
            parts = {const.str.SPM_NORM_FILE_IMPORT_BRAIN, ...
                     const.str.SPM_NORM_FILE_IMPORT_CORTEX};
            [selection, IsOK] = listdlg('PromptString', prompt,...
                                        'SelectionMode', 'multiple', ...
                                        'ListString', parts);
            if ~IsOK, return; end
            opt_arg1 = parts(selection);
        end

        % Wait dialog
        drawnow;
        h = msgbox('Please wait...');
        
        % get analyze file for coordinate change
        analyze_file = bm_view_parm2d_get_analyze_file(obj.view_setting2d);

        % Data import
        [obj.bmm, result, index] = bm_manager_import_file(obj.bmm, ...
                                                        file_type, ...
                                                        model_file, ...
                                                        analyze_file, ...
                                                        opt_arg1, ...
                                                        opt_arg2, ...
                                                        opt_arg3);
        if result == SUCCESS
            % update screen
            set(H.brain_model_list_listbox, 'Value', 1);
            obj = bm_edit_app_update_brain_model_listbox(obj);
            % View close
            obj = bm_edit_app_close_all_view(obj);
        end
        if ishandle(h), close(h); end

    case H.export_push
        index = get(H.brain_model_list_listbox, 'Value');
        [file_name, cancelled] = bm_edit_app_util_put_file({'.head.mat'}, '');
        if ~cancelled
            [obj.bmm, result] = bm_manager_export_file(obj.bmm, ...
                                                const.file_type.HEAD_FILE,...
                                                file_name, ...
                                                index);
            if result == FAILURE
                errordlg('head file export failed.', 'error');
            end
        end
        
    %
    % --- Load / Save Application info
    %
    case H.load_menu
        [file_name, cancelled] = bm_edit_app_util_get_file(...
                                            {'.bme.mat'},...
                                            'Select application setting file.');
        if cancelled, return; end
        analyze_file = [];
        load(file_name, 'bmm', 'view_setting2d', 'view_setting3d', 'analyze_file');
        obj.bmm = bmm;
        obj.view_setting2d = view_setting2d;
        obj.view_setting3d = view_setting3d;
        set(H.analyze_file_edit, 'String', analyze_file);
        obj = bm_edit_app_update_brain_model_listbox(obj);
        % View close
        obj = bm_edit_app_close_all_view(obj);

    case H.save_menu
        [file_name, cancelled] = bm_edit_app_util_put_file({'.bme.mat'}, 'Save application setting file.');
        if cancelled, return; end
        bmm = obj.bmm;
        analyze_file = get(H.analyze_file_edit, 'String');
        view_setting2d = obj.view_setting2d;
        view_setting3d = obj.view_setting3d;
        vb_save(file_name, 'bmm', 'view_setting2d', 'view_setting3d', 'analyze_file');
    
    %
    % --- listbox click
    %
    case H.brain_model_list_listbox
        set(H.history_listbox, 'Value', 1);
        obj = bm_edit_app_update_brain_model_listbox(obj);
    case H.history_listbox
        obj = bm_edit_app_update_history_listbox(obj);
    
    %
    % --- View button push
    %
    case H.view2d_push
        % Wait dialog
        drawnow;
        h = msgbox('Please wait...');
        % Singleton check
        if isempty(obj.view2d) || bm_edit_app_view_is_opening(obj.view2d) == false
            obj.view2d = bm_edit_app_view2d_new;
        end
        obj.view2d = bm_edit_app_view_update(obj.view2d, obj, ...
                                             @bm_edit_app_get_display_factor, ...
                                             obj.view_setting2d);
        if ishandle(h), close(h); end
    case H.view3d_push
        % Wait dialog
        drawnow;
        h = msgbox('Please wait...');
        % Singleton check
        if isempty(obj.view3d) || bm_edit_app_view_is_opening(obj.view3d) == false
            obj.view3d = bm_edit_app_view3d_new;
        end
        obj.view3d = bm_edit_app_view_update(obj.view3d, obj, ...
                                             @bm_edit_app_get_display_factor, ...
                                             obj.view_setting3d);
        if ishandle(h), close(h); end
    %
    % --- Processing menu
    %
    case {H.processing_surf_smooth_menu,...
          H.surf_smooth_push,...
          H.processing_surf_smooth_expand_menu,...
          H.surf_smooth_expand_push,...
          H.processing_surf_to_filled_mask_menu,...
          H.surf_to_filled_mask_push,...
          H.processing_separate_surf_menu,...
          H.close_surf_push, ...
          H.separate_surf_push,...
          H.processing_morphology_operation_menu,...
          H.morphology_operation_push,...
          H.processing_surf_extract_menu,...
          H.surf_extract_push}

        % Convert key to parm_type
        parm_type = bm_edit_app_menu_to_parm_type(obj, hObj);
        % edit parameter
        parm = bm_manager_get_process_parameter(obj.bmm, parm_type);
        [parm, cancelled] = process_parm_editor_edit(obj.ppm, ...
                                                    parm_type, ...
                                                    parm);
        if cancelled, return; end
        % set parameter
        [obj.bmm, result] = bm_manager_set_process_parameter(obj.bmm, ...
                                                            parm_type, ...
                                                            parm);
        if result == FAILURE
            errordlg('Invalid parameter is inputted.', 'error');
            return;
        end
        % wait dialog
        h = msgbox('Please wait...');
        drawnow;
        % execute processing
        index = get(H.brain_model_list_listbox, 'Value');
        obj.bmm = bm_manager_process_brain(obj.bmm, parm_type, index);
        if ishandle(h), close(h); end
        obj = bm_edit_app_update_brain_model_listbox(obj);
   %
   % --- Setting color
   %
    case H.color_setting_2d_menu
        color_cell = bm_view_parm2d_get_color(obj.view_setting2d);
        for k=1:length(color_cell)
            parm_name{k} = ['Layer' num2str(k)];
        end
        color_cell = inputdlg(parm_name, '2D color setting', 1, color_cell, 'on');
        if isempty(color_cell)
            return;
        else
            % Check inputted color
            for k=1:length(color_cell)
                color = color_cell{k};
                if isletter(color(2))
                    errordlg('Inputted color is invalid.');
                    return;
                end
            end
            % Save Color setting
            obj.view_setting2d = bm_view_parm2d_set_color(obj.view_setting2d, color_cell);
            % update 2D view
            if isempty(obj.view2d) || bm_edit_app_view_is_opening(obj.view2d)
                bm_edit_app_callback(obj, H.view2d_push);
            end
        end
    %
    % --- Other command
    %
    case H.delete_push
        % Selected model delete
        index = get(H.brain_model_list_listbox, 'Value');
        obj.bmm = bm_manager_delete_model(obj.bmm, index);
        % Adjust listbox line
        if index(1) == 1
            set(H.brain_model_list_listbox, 'Value', 1);
        else
            set(H.brain_model_list_listbox, 'Value', index(1)-1);
        end
        % Display update
        obj = bm_edit_app_update_brain_model_listbox(obj);
    case H.rename_push
        % get selected model name
        index = get(H.brain_model_list_listbox, 'Value');
        name = bm_manager_get_model_name(obj.bmm, index);
        % Input new model name
        new_name = inputdlg('New name', 'Input new model name', 1, name);
        % cancel check
        if isempty(new_name), return; end
        % Rename
        obj.bmm = bm_manager_rename_model(obj.bmm, index, new_name{1});
        % update display
        obj = bm_edit_app_update_brain_model_listbox(obj);
    case H.conductivity_push
        % Selected model is changed
        index = get(H.brain_model_list_listbox, 'Value');
        new_conductivity = str2double(get(H.conductivity_edit, 'String'));
        % Change conductivity
        obj.bmm = bm_manager_change_conductivity(obj.bmm, index, new_conductivity);
        % update display
        obj = bm_edit_app_update_brain_model_listbox(obj);
end

%
% --- Save bm_edit_app object to figure
%
guidata(obj.h, obj);
