function [obj] = vb_batch_variable_table_new(column_name_list)
% This is a constructor of vb_batch_variable_table class.
% This class preserves 2D matrix of variable.
% [USAGE]
%    [obj] = vb_batch_variable_table_new([column_name_list][,table])
% [IN]
%    column_name_list : Column name list for table
% [OUT]
%    obj : vb_batch_variable_table
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


%
% --- Previous check
%
if ~exist('column_name_list', 'var')
    column_name_list = {'$ID$'};
end
if ~exist('table', 'var')
    data = cell(0);
    table{1,1} = 'SBJ1';
end

if ~iscellstr(column_name_list)
    error('column_name_list should include only string');
end

if ~iscellstr(table)
    error('table should include only string');
end

%
% --- Main Procedure
%


% obj.
%   column_name_list = {'$VAR1$', '$VAR2$'} {1xN}
%   table            = {1,1}      {1,2}     {NxM}
%                      {2,1},     {2,2},
%                      ...        ...
obj = struct;
obj.column_name_list = column_name_list;
obj.table = table;

%
% --- After check
%
if nargout < 1
    error('function caller should receive obj.');
end
