function [obj, errmsg] = ...
    vb_batch_variable_table_add_column(obj, new_column_name)
% added new column
% [USAGE]
%    obj = vb_batch_variable_add_column(<obj>, <new_column_name>);
% [IN]
%                obj : vb_batch_variable_table object
%    new_column_name : new column name such as '$SUBJECT' [STRING]
% [OUT]
%       obj : vb_batch_variable_table object
%    errmsg : if error is occured, reason will be contained.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('new_column_name', 'var')
    error('new_column_name is a required parameter.');
end
if ~ischar(new_column_name) || isempty(new_column_name)
    error('invalid column name is given');
end

%
% --- Main Procedure
%
errmsg = [];

ix = strmatch(new_column_name, obj.column_name_list, 'exact');
if ~isempty(ix)
    errmsg = 'Specified variable name already exists.';
    warning(errmsg);
else
    % Add column
    [M, N] = size(obj.table);
    obj.table = [obj.table, cell(M,1)];
    obj.column_name_list{1, N+1} = new_column_name;
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
