function vb_batch_mgr_show_parm_contents(obj, ix_main, ix_sub)
% Show parameter fields by using text area.
% [USAGE]
%    vb_batch_mgr_show_parm_contents(<obj>, <ix_main>, <ix_sub>);
% [IN]
%        obj : vb_batch_mgr object
%    ix_main : parameter set specifier
%              = 0 : template parameter set
%              >=1 : batch parameter set
%     ix_sub : index in the parameter set.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub', 'var')
    error('ix_sub is a required parameter.');
end

%
% --- Main Procedure
%

% get parameter set(template or batch parameter set)
parm_set = vb_batch_mgr_get_parm_set(obj, ix_main);

% get parameter from parameter set
[parm, parm_type] = vb_batch_parm_set_get_parm(parm_set, ix_sub);

file = vb_struct2file(parm);

fid = fopen(file, 'rt');
if fid == -1
    warning('temporary file cannot be created.');
    return;
end

parm_str = '';
while(1)
    line = fgets(fid);
    if line == -1
        break;
    else
        parm_str = [parm_str, line];
    end
end
fclose(fid);

[h, h_edit] = vb_text_area(parm_type, parm_str);
