function [obj, errmsg] = vb_batch_mgr_edit_parm(obj, ix_main, ix_sub)
% Edit parameter
%
% [USAGE]
%    [obj] = vb_batch_mgr_edit_parm(<obj>, <ix_main>, <ix_sub>);
% [IN]
%        obj : vb_batch_mgr object
%    ix_main : parameter set specifier
%              = 0 : template parameter set
%              >=1 : batch parameter set
%     ix_sub : index in the parameter set.
% [OUT]
%       obj : vb_batch_mgr object
%    errmsg : if error occured, the reason will be containd.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('ix_main', 'var')
    error('ix_main is a required parameter.');
end
if ~exist('ix_sub', 'var')
    error('ix_sub is a required parameter.');
end
%
% --- Main Procedure
%
errmsg = '';

if isempty(ix_main) || isempty(ix_sub)
    return;
end

% get specified parameter set
parm_set = vb_batch_mgr_get_parm_set(obj, ix_main);

% get parameter
[parm, parm_type] = vb_batch_parm_set_get_parm(parm_set, ix_sub);

% edit parameter
updated_parm = vb_parm_editor_gui(parm, parm_type);

% set updated parameter set to the vb_batch_mgr object
if ~isempty(updated_parm)
    [obj, errmsg] = ...
        vb_batch_mgr_set_parm(obj, ix_main, ix_sub, updated_parm, parm_type);
end

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
