function vb_batch_list_update_build_part(fig)
% update build part gui
% [USAGE]
%    vb_batch_list_update_build_part(<fig>);
% [IN]
%    fig : figure handle
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
data = guidata(fig);


% Choose IDs for output
Ncreated = vb_batch_mgr_get_num_of_parm_set(data.bmgr);
on_off = 'on';
if Ncreated == 0
    on_off = 'off';
end
set(data.H.choose_id_list_push, 'Enable', on_off);


% listbox for IDs
[id_list_str] = vb_batch_mgr_get_output_id_string(data.bmgr);
on_off = 'on';
if isempty(id_list_str)
    on_off = 'off';
end
set(data.H.batch_output_listbox, 'String', id_list_str);
set(data.H.build_batch_push, 'Enable', on_off);
