function vb_job_fmri_adv(parm)
% IMPORT FMRI RESULTS TO VBMEG ACT AND AREA FILES (ADVANCED MODE)
%
% * Assume all the SPM images are aligned to the corresponding subject
% T1-image using SPM. 
% * Advanced knowledge on percent signal changes is required.
% * SPMimginfo must be defined in parm with the following format.
%
% [Input]
% parm
%   .brain_file : brain file
%   .act_file   : act file 
%   .area_file  : area file
%   .Tthres     : T-value threshold  (unit : a.u.)
%   .PSthres    : percent-signal threshold (unit : %)
%   .Rthres     : radius threshold (unit : mm) 
% 
% parm.SPMimginfo(nn) (one struct defines one image)
%       .dirname : directory name for image file 
%       .imgfilename :  file name of an image to be projected  
%       .imglabel    :  label of image to be projected. This label is
%       used as act_key and area_key.
%
% If you want to import PS maps, please specify con*.img to imgfilename and
% the following field;
%
%       .baseimgfilename :  file name for the baseline image (constant regressor) 
%       .ncon         :  the number of positive contrast for each CON image
%       .peak         :  regressor peak value
% 
%
% 2016/07/26
% First version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~isfield(parm, 'SPMimginfo')
    help vb_job_fmri2_adv
    error('SPMimginfo must be defined !');
end

% PARAMETERS
brain_file  = parm.brain_file;

% Resutls output 
act_file    = parm.act_file;
area_file   = parm.area_file;

% function mode
Tthres  = parm.Tthres;      % important parameters
Rthres  = parm.Rthres;      % unit:mm
PSthres = parm.PSthres;     % unit:%
SPMimginfo = parm.SPMimginfo;

% check SPMimginfo
ck = check_SPMimginfo(SPMimginfo);

if ck == 0, 
    error('SPMimginfo does not have enough information !');
elseif ck == 1
    vb_fmri_project_Tmap_cortex(brain_file,act_file,area_file,Tthres,Rthres,SPMimginfo);
elseif ck == 2
    vb_fmri_project_PSmap_cortex(brain_file,act_file,area_file,PSthres,Rthres,SPMimginfo);
end


%
% inner function
%

function ck = check_SPMimginfo(SPMimginfo)

ck = 0;

for nn = 1 : length(SPMimginfo)

    
    if isfield(SPMimginfo(nn),'dirname') & isfield(SPMimginfo(nn),'imgfilename') &...
            isfield(SPMimginfo(nn),'imglabel') 
        ck = 1;
       
        if isfield(SPMimginfo(nn),'baseimgfilename') & isfield(SPMimginfo(nn),'ncon') &...
            isfield(SPMimginfo(nn),'peak') 
 
            ck = 2;
        end
    else 
        ck = 0;
    end
    
  
end


