function vb_fmri_unsn_project_PSmap_cortex(brain_file,act_file,area_file,sn_file,PSthres,Rthres,SPMimginfo)
% PROJECT VOXEL PERCENT SIGNAL MAP ON THE BRAIN SURFACE MODEL
%
% [Notice]
% con_*.img must be normalized to the standard brain using T1-structural image used for creating
% a brain file.
%
% [Input]
%   brain_file : cortical surface model 
%   act_file   : act file 
%   area_file  : area file
%   Tthres     : T-value threshold 
%   Rthres     : radius threshold (mm)
%   SPMimginfo(ii) : arrays of struct containing information of T-image  
%       .dirname : directory name for image file 
%       .imgfilename :  file name of image to be projected  
%       .imglabel    :  label of image to be projected. These label
%                            are used as actkey and areakey
%       .baseimgfilename :  file name for the baseline image
%       .ncon         :  the number of positive contrast for each CON image
%       .peak         :  regressor peak value
%       .spm_ver      :  spm version
% 
% [Output]
%   Acts are added to "act_file" and Areas are added to "area_file"
%
% Reference : see http://cibsr.stanford.edu/documents/FMRIPercentSignalChange.pdf 
%    
% 2016/07/26 O.Yamashita
% * 'spm_ver' moves to 'SPMimginfo'. 
% 2016/07/06 O.Yamashita
% * solve the region expansion problem
% 2016/07/01 O.Yamashita
% * first version based on vbdot_fmri_project_Tmap_corext.m
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


spmdir = SPMimginfo(1).dirname;
spm_ver = SPMimginfo(1).spm_ver;

fprintf('Image directory name : %s,...\n', spmdir);
for jj = 1 : length(SPMimginfo),
    fprintf('%s will be registered as %s ...\n', SPMimginfo(jj).imgfilename, SPMimginfo(jj).imglabel);
end

% scale factor for con image

for jj = 1 : length(SPMimginfo),
    loadimgfile = [spmdir SPMimginfo(jj).imgfilename];
    key = SPMimginfo(jj).imglabel;
    
    baseimgfile = [spmdir SPMimginfo(jj).baseimgfilename];
    [B] = vb_load_analyze_to_right(baseimgfile);
    bmean = mean(B(~isnan(B(:))));
    scale = 1./SPMimginfo(jj).ncon/bmean*SPMimginfo(jj).peak*100;
    
   
    % surface mesh
    V = vb_load_cortex(brain_file, 'subj');
    V = V * 1000;  % mm
      
    
    % vox image and coordinates
    VG=spm_vol(loadimgfile);
    [map,XYZ] = spm_read_vols(VG);
    map = map * scale;

    %
    % thresholding affects resulting surface image !!!
    %
   
    %     map(abs(map) < PSthres) = NaN;
    %     ix=find(~isnan(map));
    %     XYZ = XYZ(:,ix);
    %     map = map(ix)';
    ix = find(~isnan(map));  % brain mask
    XYZ = XYZ(:,ix);
    map = map(ix);
    map(abs(map) < PSthres) = 0; %


    r2thres = Rthres^2;
    
    % standard brain --> individual brain
    XYZmm = backword_transform_normalized_to_subject_native(sn_file, spm_ver, XYZ');
    
    % vox --> surf 
    Tval = vb_voximg2surimg(XYZmm,map,V, r2thres, 1);

    
   % add act 
    fprintf('\nAdd PS-map to %s with act-key %s \n', act_file, key)
    act.xxP = Tval;
    act.key = key;
    act.spmdir  = spmdir;
    act.imgname = SPMimginfo(jj).imgfilename;
    load(act_file, 'MRI_ID');
    vb_add_act(act_file, act, MRI_ID, OFF);

%       % add area 
%     fprintf('Add PS-map to %s with area-key %s \n', area_file, key)
%     area.Iextract = find(Tval~=0);
%     area.key = key;
%     area.spmdir  = spmdir;
%     area.imgname = SPMimginfo(jj).imgfilename;
%     vb_add_area(area_file, area);
    
    
end

function XYZmm = backword_transform_normalized_to_subject_native(snfile, spm_ver, XYZmm_mni)
% XYZmm_mni : Nvox*3

switch (lower(spm_ver))
 case 'spm2', 
  sn = load(snfile);
  XYZmm=vb_unsn(XYZmm_mni,sn);
  
 case {'spm5','spm8'}, 
  XYZmm = spm_get_orig_coord_spm5(XYZmm_mni,snfile);
end;