function [B,Ntrials,Nsensors,Tsample,Twindow,Tmsec] = ...
    vb_megdata_preparation(bayes_parm)
% Prepare MEG data from bayes_parm.
%
% [history]
% 2008-10-14 Taku Yoshioka
% 2011-05-11 taku-y
%  [minor] New output variable 'Tmsec' was added. This is a vector of
%  actual time of row of B{n}. 
% 2011-11-16 taku-y
%  [major] Offset of time index was corrected. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% fields of bayes_parm used in this function
vb_struct2vars(bayes_parm,{'megfile', 'twin_meg', 'temporal_filter', ...
    'trial_average','Tperiod','Tnext','ix_trial'})

% Get MEG data for all sessions
[B,Ntrials,Nsensors,Tsample,Tmsec] =...
    vb_get_megdata(megfile,twin_meg,temporal_filter,trial_average, ...
                   ix_trial);

% offset
if length(Tnext) > 1, 
	Tnext = Tnext-twin_meg(1)+1;
end

% Time window
Twindow = vb_calc_timewindow(Tsample,Tperiod,Tnext);

return;