function [KW, KW0, Var] = ...
   vb_invfilter_calc(a_inv, v_inv, G, GbW, GG, Cov, Wact, Wbck)
% Calculate Inverse filter for current reconstruction
%   [KW, KW0, Var] = ...
%      vb_invfilter_calc(a_inv, v_inv, G, GbW, GG, Cov, Wact, Wbck)
%
% --- Input
% a_inv : A    :  variance of active current                    
% v_inv : tau  : variance of active current                   
% G     : Ga : leadfield of active current (smoothed) G0*Wa  
% GbW   =  Gb*Wb' = G0*Wb*Wb'
% Gb    : leadfield of background current (smoothed) G0*Wb
% GG    =  Gb*Gb'
% Wact  : Wa : spatial smoothing matrix of active current    
% Wbck  : Wb : spatial smoothing matrix of background current
% Cov   : Sensor noise covariance matrix
% ---Output
% KW   : Inverse filter for active current
% KW0  : Inverse filter for background current
% Var  : posterior variance
%   When active area is empty,
%   posterior variance for background area is calculated
%
% --- Current reconstruction
% Jact = (KW  * Bt);
% Jbck = (KW0 * Bt);
%
% 2006-9-1 M.Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Nvact  # of vertex in focal area
% Nvex   # of extended vertex for focal area
% Nvbck  # of extended vertex for global area

% Nact   # of estimated variance in focal area
% Njact  # of current in focal area
% Njbck  # of current in global area

error('This function is a canditate to be removed, but invoked.');

[Nvex, Nvact] = size(Wact);
[Nch,  Njact] = size(G);

Nvbck = size(Wbck,1);
Njbck = size(GbW,2);
Nact  = length(a_inv);

Ratio = Njact/Nact;  % Njact = Ratio * Nact
Lact  = Njact/Nvact; % Njact = Lact  * Nvact

if Nvbck > 0,
	Lbck  = Njbck/Nvbck; % Njbck = Lbck  * Nvbck
else
	Lbck  = Lact;
end

A_inv  = repmat(a_inv , [Ratio Nch]); % [Njact x Nch]
AGt    = A_inv .* G';          % A*Ga'
GGA    = G * AGt + v_inv * GG; % Ga*A*Ga' + tau*Gb*Gb'
SB_inv = inv( GGA + Cov );     % SB^(-1) = [Ga*A*Ga' + tau*Gb*Gb'+Cov]^{-1} 		
% Wa*A*Ga'
WAGt  = Wact * reshape(AGt, [Nvact Lact*Nch]); % [Nvex x Lact*Nch]
WAGt  = reshape(WAGt, [Nvex*Lact Nch]);        % [Nvex*Lact x Nch]

%switch Lact
%case 1, 
%	WAGt  = Wact*AGt;   
%case 2, 
%	WAGt  = [Wact*AGt(1:Nvact,:); Wact*AGt(Nvact+(1:Nvact),:)];
%case 3,
%	WAGt  = [Wact*AGt(1:Nvact,:); Wact*AGt(Nvact+(1:Nvact),:);  ...
%             Wact*AGt(2*Nvact+(1:Nvact),:)];
%end

%%%% Inverse filter
KW  = WAGt * SB_inv;            % Wa*A*Ga'*(SB)^{-1}   : active
KW0 = v_inv .* (GbW' * SB_inv); % tau*Wb*Gb'*(SB)^{-1} : back 

if nargout < 3, return; end;

%%%% Posterior variance calculation
% diagonals of WAW = diag(Wa*A*Wa')
WAW  = sum( (Wact*spdiags(a_inv,0,Nvact,Nvact)).*Wact ,2 );

% Posterior variance
if Nvex > 0
	if Nvbck == Nvex
	    % PP = (Wa*A*Ga') + v_inv*(Wb*Gb')
	    PP = (WAGt + v_inv .* GbW' );
	    % Wa*A*Wa' + tau*Wb*Wb' - (Wa*A*Ga'+tau*Wb*Gb')*SB_inv*(...)'
	    Var = repmat(WAW , [Lact, 1]) ...
	        + v_inv * repmat(sum(Wbck.*Wbck,2),[Lact,1]) ...
		    - sum((PP*SB_inv).*PP ,2) ;
	else
	    % Wa*A*Wa' - (Wa*A*Ga')*SB_inv*(...)'
	    Var  = repmat(WAW , [Lact, 1]) ...
			 - sum((WAGt*SB_inv).*WAGt ,2) ;
	end
elseif Nvbck > 0
    % tau*Wb*Wb' - (tau*Wb*Gb')*SB_inv*(...)'
    Var  = v_inv * repmat(sum(Wbck.*Wbck,2),[Lbck, 1]) ...
		 - v_inv^2 * sum(GbW.*(SB_inv*GbW) ,1)' ;
end

