function [nG_focal, ix_focal, ix_focal_ex, W_focal, L_focal, bsnorm] ...
    = vb_focal_leadfield_preparation(bayes_parm, bsnorm)
% Prepare leadfield of focal and global window
%
% -- Output
% nG_focal    : normalized leadfield of focal window
% bsnorm      : normalizing constant
% 
% ix_focal    : vertex indices of focal window
% ix_focal_ex : vertex indices of expandend focal window
% W_focal     : spatial smoothing matrix of focal window
% L_focal     : number of dipole orientation of focal window
%
% 2005/08/16 O.Yamashita
% 2005/08/22 O.Yamshita ver.30b
% 2006/03/03 Taku Yoshioka, Support patch size normalization
% 2006/08/25 M. Sato sepalate leadfield_preparation to focal & global
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~isfield(bayes_parm, 'patch_norm')
    bayes_parm.patch_norm = ON;
end

% fields of 'bayes_parm' used in this function
vb_struct2vars(bayes_parm,{'brainfile', 'areafile', 'reduce', 'Rfilt', ...
	'expand_spatial_filter', 'basisfile', 'area_key', 'patch_norm', 'basis_smoother'});

%% Leadfield matrix of focal window
fprintf('--- Lead field matrix of focal window \n');
[G_focal, L_focal, W_focal, ix_focal, ix_focal_ex] = vb_prepare_leadfield(...
    basisfile, brainfile, areafile, area_key, reduce, ...
    Rfilt, expand_spatial_filter, patch_norm, [], basis_smoother);

Nsession = length(G_focal);  % Number of sessions

%% leadfield normalization 
if ~exist('bsnorm','var') | isempty(bsnorm)
	Bnorm = zeros(Nsession,1);
	
	for n = 1: Nsession
	    GG_focal = sum(G_focal{n}.^2, 2);
	    Bnorm(n) = sum(GG_focal)/length(GG_focal); 
	end

	% Normalization constant of lead fields
	bsnorm = sqrt(mean(Bnorm)); 
end

% Normalization of lead fields
for n=1:Nsession
  nG_focal{n} = G_focal{n}/bsnorm;
end;

