function	[Zp ,post]= vb_current_calc(Bt,KW,SB_cov,Hj,sx)
% Calculate current using inverse filter
% [Zp]= vb_current_calc(Bt,KW)
% [Zp ,post]= vb_current_calc(Bt,KW,SB_cov,Hj,sx)
% --- Input
% Bt = MEG/EEG data (Nch,Tsample)
% KW = VB inverse filter  (Njact,Nch,1,Ntask)
% SB_cov = posterior sensor covariance matrix (Nch,Nch,1,Ntask)
% Hj = Model entropy (1,Ntask)
% sx = Observation noise variance (1,Ntask)
% --- Output
% Zp = current of Njact vertices (Njact,Tsample)
% post = posterior probability for each condition (Ntask,1)
%
% 2008-11-3 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

Ntask = size(KW,4);

if Ntask==1,
    % Current
    Zp  = (KW(:,:,1,1) * Bt);
    post = 1;
else
	MinExp = -50;
	Njact = size(KW,1);
	Nt = size(Bt,2);
	LP = zeros(Ntask,1);
	
	BB = Bt*Bt';
	
	for k=1:Ntask
	    % Data covariance matching
        err = sum(sum(BB.*SB_cov(:,:,1,k)));
        % Data Likelihood & Free Energy 
        LP(k) = - 0.5*(err)/sx(k) + Nt*Hj(k);
    end; 
    
    LP = max( LP - max(LP) , MinExp);
    post = exp(LP);
    post = post/sum(post);

	Zp = zeros(Njact,Nt);
    
	for k=1:Ntask
	    % Current
	    Zt  = (KW(:,:,1,k) * Bt);
	    % Current
	    Zp = Zp + Zt*post(k);
	end
end
