function J = vb_convert_current_1d(J0,V,xx,L)
% Convert current vector to scalar based on normal vector on cortex
%
% --- Syntax
% J = vb_convert_current_1d(J0,V,xx,L)
%
% --- Input
% J0: IL-by-T matrix (current vector components)
% V : I-by-3 matrix (vertex position)
% xx: I-by-3 matrix (principal dipole direction)
% L : Scalar (dipole number at each vertex)
%
% --- Output
% J : I vector
%
% --- History
% 2007-03-13 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if L==1, J=J0; return; end

% Calculate vector current
I = size(V,1);
T = size(J0,2);
[V,xx_L] = vb_current_vector(V,xx,L);
Jx = J0.*repmat(xx_L(:,1),[1 T]);
Jy = J0.*repmat(xx_L(:,2),[1 T]);
Jz = J0.*repmat(xx_L(:,3),[1 T]);

switch L
 case 2,
  Jx = Jx(1:I,:)+Jx(I+1:2*I,:);
  Jy = Jy(1:I,:)+Jy(I+1:2*I,:);
  Jz = Jz(1:I,:)+Jz(I+1:2*I,:);
 case 3,
  Jx = Jx(1:I,:)+Jx(I+1:2*I,:)+Jx(2*I+1:3*I,:);
  Jy = Jy(1:I,:)+Jy(I+1:2*I,:)+Jy(2*I+1:3*I,:);
  Jz = Jz(1:I,:)+Jz(I+1:2*I,:)+Jz(2*I+1:3*I,:);
end

% Directional cosine
J = Jx.*repmat(xx(:,1),[1 T])+Jy.*repmat(xx(:,2),[1 T]) ...
    +Jz.*repmat(xx(:,3),[1 T]);
