function [v2,sx2] = vb_baseline_variance_acquisition(bayes_parm,nGall,Cov,sx);
% ACQUIRE THE CURRENT VARIANCE OF BASELINE  
%
% --- Syntax
% 1. [v2,sx2] = vb_baseline_variance_acquisition(bayes_parm,nGall);
% 2. [v2,sx2] = vb_baseline_variance_acquisition(bayes_parm,nGall,Cov,sx);
%
% 1. Update sx and v using a spherical covariance Cov = I (identity matrix)
% 2. Fix sx using a given covariance matrix Cov
%
% --- Input
% (Field of bayes_parm)
% .megfile         : MEG file for current variance estimation
% .twin_baseline   : Time window for current variance estimation
% .megfile_baseline: MEG file for noise calculation
% .twin_noise      : Time window for noise estimation
% .noise_reg       : Regularization parameter for noise covariance
% .a_min           : 
% .a_max           :
% .Fdmin           :
% .update_v        : (ɬפ)
% .update_sx       : (ɬפ)
% .basisfile_global: (ɬפ)
% .basisfile       : (ɬפ)
% .variance_orientation: 
% .Tv0             :
% .Ta0             : 
% .temporal_filter (optional): 
% .trial_average   (optional): 
%
% --- History
% 2005-08-17 O. Yamashita, ver.30b
% 2005-08-17 O. Yamashita
% 2006-08-10 M. Sato
%   Use 'vbmeg_multi_fmri' for estimation
% 2008-06-30 Taku Yoshioka 
%   twin_global -> twin_baseline
% 2011-08-26 taku-y
%  [minor] 'bayes_parm.megfile_baseline' became effective. 
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin ~= 2 & nargin ~=4
  error('Input arguments must be 2 or 4')
end

Njall = size(nGall{1},2);

bayes_parm2 = bayes_parm;

bayes_parm2.twin_meg = bayes_parm2.twin_baseline; 
bayes_parm2.Tperiod  = ...
    bayes_parm2.twin_meg(2) - bayes_parm2.twin_meg(1) + 1;
bayes_parm2.Tnext = bayes_parm2.Tperiod;

bayes_parm2.Npre_train  = 100;	% = Ntrain
bayes_parm2.Ntrain      = 100;	% : Do not use accelerated-update rule
bayes_parm2.skip        = 20;
bayes_parm2.noise_model = 1;	% Scaler noise model

% modified by TY 2011-08-26
bayes_parm2.megfile = bayes_parm.megfile_baseline; 

if nargin == 2    
  % Estimate sensor noise variance 
  wiener.update_sx = ON;
  [Cov]   = vb_observation_noise_specification(bayes_parm2);
  [B]     = vb_megdata_preparation(bayes_parm2);
  vb_parm = vb_set_vb_parm(bayes_parm2, B, [], Njall);
elseif nargin == 4
  % Fix sensor noise variance 
  wiener.update_sx = OFF;
  [B]     = vb_megdata_preparation(bayes_parm2);
  vb_parm = vb_set_vb_parm(bayes_parm2, B, [], Njall, [], sx);
end

wiener.update_v = ON;  % Estimate global current variance
vb_parm.wiener  = wiener;

% No fMRI bias information
vb_parm.Ta0 = 0;
vb_parm.Tv0 = 0;

%[Model,Info] = vbmeg_ard_estimate2(B, nGall, [], Cov, vb_parm);
[Model,Info] = vbmeg_multi_fmri(B, nGall, [], Cov, vb_parm);

v2  = Model.v(1);	% global current variance
sx2 = Model.sx;		% noise variance
