function [a_init] = vb_calc_initialvalue_a...
  (bayesinitfile, brainfile, dmri_file, bsnorm, a_min)
% Calculate initial values of current variance parameter for source 
% connectivity estimation
%
% Input:
%  bayesinitfile : Bayes file.(.bayes.mat)
%  brainfile     : Cortical model file(.brain.mat)
%  dmri_file     : diffusion MRI file(.dmri.mat) 
%  bsnorm        : Normalization constant of lead field matrix
%  a_min         : Minimum value of current variance parameter (= vb_parm.a_min)
%
% Output:
%  a_init [~1840 x 1]
%   Initial values of current variance parameter (= vb_parm.a)
%
% 2015/01/29 M.Fukushima
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

load(bayesinitfile, 'Model');

% [membershipmat] = make_membershipmat(proj_root, brainfile, parcelsfile);
% note: this information is contained in Diffusion mri file(.dmri.mat)
load(dmri_file, 'membershipmat');


Model.a = membershipmat(:,Model.ix)*Model.a; % Works only if patch_norm == OFF

% Initial values of current variance parameter
a_init = max(Model.a*(bsnorm^2), a_min);
