function [KW, GSB, SB] = calc_kalman_gain(G, Gt, ax_z, Cov, flag_pinv)
%
% Calcurate Kalman gain matrix
%
% 2010/07/15 M.Fukushima
% 2012/12/10 M.Fukushima
% 2013/06/26 M.Fukushima

GSG     = G * vb_repmultiply(Gt, ax_z) ; 
SB      = GSG + Cov;                 % Sigma_B
if flag_pinv, SB_inv  = pinv( SB );  % Sigam_B^{-1}
else SB_inv  = inv(SB); end
GSB     = Gt*SB_inv;                 % Ga' * Sigma_B^{-1}

% Kalman gain matrix
KW = vb_repmultiply(GSB, ax_z);
