function	[Nskip, Nline, Mmax] = vb_read_vrml_line(fname,key,form)
% Read Coordinate frpm XML-file
% 
% Coordinate3 {
%	point [ 
%		9.06 87.16 -851.32,
%		10.02 87.13 -851.20,
%			...
%	]
%	point [ 9.06 87.16 -851.32,
%		10.02 87.13 -851.20,
%			...
%       76.95 -72.55 23.16 ]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('form','var'), form = '%f'; end;

key_start  = key.start ;
key_start2 = key.start2;
key_end    = key.end   ;
key_braket = key.braket;

% check line number
fid=fopen(fname);

if fid == -1, fprintf('[%s] can not be opened\n',fname);return; end;

Nskip  = 0;

while 1
    next_line = fgetl(fid);
    Nskip = Nskip+1;
    if ~ischar(next_line), break, end;
	if ~isempty( strfind(next_line,key_start)), break, end;
end

while 1
    next_line = fgetl(fid);
    Nskip = Nskip+1;
    if ~ischar(next_line), break, end;
	if ~isempty( strfind(next_line,key_start2)), break, end;
end

% from now on data is written
% Count number of data lines
Nline  = 0;
Mmax   = 0;

% Check case such as [ 12, 13, 
ix  = strfind(next_line,key_braket);

if ~isempty(ix)
	next_line = next_line(ix+1:end);
	
	if ~isempty(next_line)
		x   = sscanf(next_line,'%f');
		if ~isempty(x), 
			Nline = Nline+1; 
		end;
	end
end

while 1
    next_line = fgetl(fid);
    if ~ischar(next_line), break, end;
    
    ix = strfind(next_line,key_end);
    
	if ~isempty( ix ), 
		tmp = next_line(1:ix-1);
		x   = sscanf(tmp,'%f');
		if ~isempty(x), Nline=Nline+1; end;
		break, 
	end;
    
    Nline=Nline+1;
	x = sscanf(next_line,form);
	Mmax=max(Mmax,length(x));
end

fclose(fid);
