function    [Coord] = vb_read_vivid_mgf(fname,mode)
% Read VIVID Image from MGF file
% --- Input
% fname.Left  = [dir subj '_left_non_reduce_MGF.mgf' ];
% fname.Right = [dir subj '_right_non_reduce_MGF.mgf'];
% fname.Front = [dir subj '_front_non_reduce_MGF.mgf'];
%
% coord_mode = 0 ɸѴ̵
% coord_mode = 1; VIVID -> SPM-R
%  Vivid original format
%   X: ->
%   Y: ->
%   Z: ->
%  SPM-R
%   X: ->
%   Y: ->
%   Z: ->
% --- Output
% Coord : Left / Right /Front  head coordinate
%  'non_reduce_MGF'- File
%        .LV   / .RV   / .FV   : 3D-Coordinate   : [Npoint 3]  [m]
%        .LF   / .RF   / .FF   : Patch index     : [Npatch 4]
%        .Limg / .Rimg / .Fimg : 3D RGB image    : [Npoint 3]
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 2006/2/2  M. Sato 

if ~exist('mode','var'), mode = 1; end;

if isfield(fname ,'Left')
	[V, F, img] = vb_read_mgf_file(fname.Left);
	
	% Change Vivid Right-hand (mm) coord. to Right-hand SPM (m) coord.
	V  = vb_vivid_mm_to_spm_right(V,mode);
	
	Coord.LV   = V  ;
	Coord.LF   = F  ;
	Coord.Limg = img;
	
	NPL = size(V,1);
	
	fprintf('Number of points in vivid 3D-Left-image= %d\n',NPL)
end

if isfield(fname ,'Right')
	[V, F, img] = vb_read_mgf_file(fname.Right);
	
	% Change Vivid Right-hand (mm) coord. to Right-hand SPM (m) coord.
	V  = vb_vivid_mm_to_spm_right(V,mode);
	
	Coord.RV   = V  ;
	Coord.RF   = F  ;
	Coord.Rimg = img;
	
	NPR = size(V,1);
	
	fprintf('Number of points in vivid 3D-Right-image= %d\n',NPR)
end
	
if isfield(fname ,'Front')
	[V, F, img] = vb_read_mgf_file(fname.Front);
	
	% Change Vivid Right-hand (mm) coord. to Right-hand SPM (m) coord.
	V  = vb_vivid_mm_to_spm_right(V,mode);
	
	Coord.FV   = V  ;
	Coord.FF   = F  ;
	Coord.Fimg = img;
	
	NPF = size(V,1);
	
	fprintf('Number of points in vivid 3D-Front-image= %d\n',NPF)
end

