function [info] = vb_info_set_transinfo(info, trans_info)
% set transform information to MEGinfo or EEGinfo
% [usage]
%   [info] = vb_info_set_transinfo(info, trans_info)
% [input]
%         info : <required> <<struct>> MEGinfo or EEGinfo
%   trans_info : <optional> <<struct>> TransInfo - transform information
% [output]
%         info : updated struct (MEGinfo or EEGinfo)
% [note]
%   For MEGinfo and EEGinfo, both trans_info formats are the same,
%   info.device_info.TransInfo
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('trans_info', 'var'), trans_info = []; end
[info, trans_info] = inner_check_arguments(info, trans_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
info.device_info.TransInfo = trans_info;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function[info, trans_info] = inner_check_arguments(info, trans_info)
func_ = mfilename;
if isempty(info)
  error('(%s) info is a required parameter', func_);
end

if isempty(trans_info)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
