function trial_list = vb_info_get_trial_list(info, user_list, active_swt)
% return list of trial index from MEGinfo or EEGinfo
% [usage]
%   trial_list = vb_info_get_trial_list(info, user_list, active_swt)
% [input]
%         info : <required> <<struct>> MEGinfo or EEGinfo
%    user_list : <optional> [N x 1] user specified index list
%              :  not being specified or empty means all the trials [[]]
%   active_swt : <optional> <<boolean>> return switch [false]
%              :   true) return only active trials
%              :  false) return all the trials
% [output]
%   trial_list : list of trial number [N x 1]
%              : narrowed by the condition of user_list and active_swt
% [note]
%   support old fashioned MEGinfo
% [history]
%   2008-04-17 (Sako) initial version
%   2008-06-06 (DK) function "inner_check_arguments" is modified
%   2009-07-07 (Sako) modified not to check active trial if it does not need
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('user_list', 'var'), user_list = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[info, user_list, active_swt] = ...
  inner_check_arguments(info, user_list, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
n_trial = length(info.Trial);
if n_trial == 0
  trial_list = [];
  return;
end

trial_list = zeros(n_trial,1);

for i_trial = 1:n_trial
  trial_list(i_trial) = info.Trial(i_trial).number;
end

if active_swt && vb_info_active_trial_is_valid(info)
  active_list = vb_info_get_active_trial(info);
  trial_list = trial_list(active_list==1);
end

if ~isempty(user_list)
  [match_idx] = vb_util_get_index(trial_list, user_list);
  trial_list = trial_list(match_idx);
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, user_list, active_swt] = ...
  inner_check_arguments(info, user_list, active_swt)

func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if ~isfield(info, 'Trial')
  measurement = vb_info_get_measurement(info);
  
  if strcmp(measurement, 'MEG')
    % for old fashioned
    n_trial = vb_info_get_Nrepeat(info);

    if isfield(info, 'TrialNumber')
      for i_trial = 1:n_trial
	info.Trial(i_trial).number = info.TrialNumber(i_trial); 
      end
    else
      % temporary measure
      for i_trial = 1:n_trial
	info.Trial(i_trial).number = i_trial;
      end
    end
  else
    info.Trial = [];
  end
end

if isempty(user_list)
  % do nothing
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
