function [trans_info] = vb_info_get_transinfo(info)
% return trans information from MEGinfo or EEGinfo
% [usage]
%   [trans_info] = vb_info_get_transinfo(info)
% [input]
%         info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%   trans_info : <<struct>> transform information
% [note]
%   if this is not set, return empty
% [hostory]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
trans_info = [];

if isfield(info, 'device_info')
  if isfield(info.device_info, 'TransInfo')
    trans_info = info.device_info.TransInfo;
  else
%     warning('device_info does not have ''TransInfo'' field\n');
  end
else
  % --- compatible with old style
  if isfield(info, 'TransInfo')
    trans_info = info.TransInfo;
  else
%     warning('info does not have ''TransInfo'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s) info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
