function [posttrigger] = vb_info_get_post_trigger(info)
% return post-trigger from current info struct
% [usage]
%   [posttrigger] = vb_info_get_post_trigger(info)
% [input]
%          info : <required> <<struct>> EEGinfo or MEGinfo(temporary)
% [output]
%   posttrigger : post-trigger value of current info struct
% [note]
%   MEGinfo does not exactly have post-trigger field.
% [hisotory]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var') info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

my_measurement = vb_info_get_measurement(info);

switch my_measurement
  case  'EEG'
    posttrigger = vb_eeginfo_get_post_trigger(info);
  case  'MEG'
    posttrigger = vb_meginfo_get_post_trigger(info);
  otherwise
    error('(%s)unexpected measurement : %s', func_, my_measurement);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
