function Nch = vb_info_get_channel_number(info, active_swt)
% get number of original channels
% [usage]
%   Nch = vb_info_get_channel_number(info, active_swt)
% [input]
%         info : <required> info struct EEGinfo or MEGinfo(unimplemented)
%   active_swt : <optional> <<boolean>> [false] switch for active channel
%              :   true) only active channels (EEG)
%              :  false) all the channels (EEG)
% [output]
%          Nch : number of original channels
% [note]
%   @see vb_meginfo_get_channel_number_whole.m
%   @see vb_eeginfo_get_channel_number.m
% [history]
%   2007-08-02 (Sako) initial version
%   2008-05-01 (Sako) added vb_info_get_channel_number
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end;
if ~exist('active_swt', 'var'), active_swt = []; end
[info, active_swt] = inner_check_arguments(info, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

measurement = vb_info_get_measurement(info);
switch measurement
  case  'EEG'
    Nch = vb_eeginfo_get_channel_number(info, active_swt);
    return;
    
  case  'MEG'
    Nch = vb_meginfo_get_channel_number_whole(info, active_swt);
    return;
    
  otherwise
    error('(%s)unknown measurement ''%s''', func_, measurment);
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, active_swt] = inner_check_arguments(info, active_swt)
if isempty(info)
  error('(%s)info is a required parameter', mfilename);
end
if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
